﻿using System;
using System.Collections;
using System.Web.UI;
using Soneta.Kadry;
using Soneta.Business;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Kasa;
using Soneta.Place;
using Soneta.Kalend;
using System.Diagnostics;
using System.Collections.Generic;
using Soneta.Web;

namespace ASP {

    public partial class Karta_Wynagrodzeń : System.Web.UI.Page {

        public string Str_CultureInfo = "pl-PL";
        public static string Str_WynPotr = "<b>WYNAGRODZENIE i POTRĄCENIA</b>";
        public static string Str_RazemBrutto = "<b>Razem brutto</b>";
        public static string Str_PodstawaSkladek = "Podstawa składek na ub. społeczne (narastająco)";
        public static string Str_SkladkiNaUS = "Składki na ubezpieczenia społeczne";
        public static string Str_KosztyUzyskania = "Koszty uzyskania";
        public static string Str_Podstawa = "<b>Podstawa opodatkowania</b>";
        public static string Str_UlgaPodatkowa = "Ulga podatkowa";
        public static string Str_Skladka775 = "<b>Składka na ubezp. zdrowotne do '7,75%'</b>";
        public static string Str_Skladka025 = "<b>Składka na ubezp. zdrowotne ponad '7,75%'</b>";
        public static string Str_ZaniechaniePoboru = "Zaniechanie poboru zaliczki podatku";
        public static string Str_Zaliczka = "<b>Zaliczka podatku do odprowadz. do US</b>";
        public static string Str_WynagrNetto = "Wynagrodzenie netto miesięczne";
        public static string Str_WynagrNarastajaco = "Wynagrodzenie netto narastająco";
        public static string Str_Wyplata = "Wypłata";
        public static string Str_NormaCzasu = "<b>NORMA CZASU PRACY</b>";
        public static string Str_DniPracy = "Dni pracy";
        public static string Str_CzasPracy = "Czas pracy";
        public static string Str_RzeczywistyCzas = "<b>RZECZYWISTY CZAS PRACY</b>";
        public static string Str_CzasNaAkordach = "Czas pracy na akordach";
        public static string Str_PozostalyCzas = "Pozostały czas pracy";
        public static string Str_Czas50 = "w tym czas pracy z dopłatą 50%";
        public static string Str_Czas100 = "w tym czas pracy z dopłatą 100%";
        public static string Str_Rok = " rok";
        public static string Str_Okres = "okres ";
        public static string Str_Title = "Karta wynagrodzeń";
        public static string Str_ReportTitle = "Karta wynagrodzeń{7} za {0} ({8})|{1}|</strong>Urodzony: <strong>{2}</strong>, <strong>{3}|</strong>NIP: <strong>{4}</strong>, PESEL: <strong>{5}|</strong>Adres: <strong>{6}";
        public static string Str_WgDatyWyplaty = "wg daty wypłaty";
        public static string Str_WgOkresuElementu = "wg okresu elementu";

        //Wydruk ma być drukowany wg daty wypłaty (true),
        //czy wg okresu za który zostały one zrealizowane (false)
        static readonly bool wgDatyWypłaty = true;

	    //Czy na wydruku ma być drukowana informacja o normie czasu pracy
	    static readonly bool normaInfo = true;
	
	    //Czy na wydruku ma być drukowana informacja rzeczywistym czasie
	    static readonly bool pracaInfo = true;

        class Total: IComparable {
    
               abstract class Item: IComparable {
                   readonly string nazwa;
                   readonly int priorytet;
                   readonly protected object[] m = new object[12];
                   protected bool narastająco = false;
                   protected Item(string nazwa, int priorytet) {
                       this.nazwa = nazwa;
                       this.priorytet = priorytet;
                   }
                   public string Nazwa {
                       get { return nazwa; }
                   }
                   public object M1 { get { return m[0]; } }
                   public object M2 { get { return m[1]; } }
                   public object M3 { get { return m[2]; } }
                   public object M4 { get { return m[3]; } }
                   public object M5 { get { return m[4]; } }
                   public object M6 { get { return m[5]; } }
                   public object M7 { get { return m[6]; } }
                   public object M8 { get { return m[7]; } }
                   public object M9 { get { return m[8]; } }
                   public object M10 { get { return m[9]; } }
                   public object M11 { get { return m[10]; } }
                   public object M12 { get { return m[11]; } }
    
                   public abstract object Razem { get; }    
                   public abstract void Narastająco();
    
                   public int CompareTo(object obj) {
                       if (obj==null)
                           return 1;
                       Item i = obj as Item;
                       if (i==null)
                           throw new ArgumentException();
                       int res = priorytet.CompareTo(i.priorytet);
                       if (res==0)
                           res = nazwa.CompareTo(i.nazwa);
                       return res;
                   }
               }

			    class DecimalItem: Item {				    
                   public DecimalItem(string nazwa, int priorytet): base(nazwa, priorytet) {
                       for (int i=0; i<12; i++)
						    m[i] = 0m;
                   }				    
                   public void Add(decimal v, int miesiąc) {
					    m[miesiąc-1] = (decimal)m[miesiąc-1] + v;
                   }
                   public override object Razem {
                       get {
                           decimal result = 0;
                           if (!narastająco)
                               for (int i=0; i<12; i++)                           
								    result += (decimal)m[i];
                           return result;
                       }
                   }
                   public override void Narastająco() {
                       narastająco = true;
                       for (int i=1; i<12; i++)
                           m[i] = (decimal)m[i-1] + (decimal)m[i];
                   }               
               }

			    class IntItem: Item {				    
                   public IntItem(string nazwa, int priorytet): base(nazwa, priorytet) {
                       for (int i=0; i<12; i++)
						    m[i] = 0;
                   }				    
                   public void Add(int v, int miesiąc) {
					    m[miesiąc-1] = (int)m[miesiąc-1] + v;
                   }
                   public override object Razem {
                       get {
                           int result = 0;
                           if (!narastająco)
                               for (int i=0; i<12; i++)                           
								    result += (int)m[i];
                           return result;
                       }
                   }    
                   public override void Narastająco() {
                       narastająco = true;
                       for (int i=1; i<12; i++)
                           m[i] = (int)m[i-1] + (int)m[i];
                   }               
               }

			    class TimeItem: Item {				    
                   public TimeItem(string nazwa, int priorytet): base(nazwa, priorytet) {
                       for (int i=0; i<12; i++)
						    m[i] = Time.Zero;
                   }				    
                   public void Add(Time v, int miesiąc) {
					    m[miesiąc-1] = (Time)m[miesiąc-1] + v;
                   }
                   public override object Razem {
                       get {
                           Time result = Time.Zero;
                           if (!narastająco)
                               for (int i=0; i<12; i++)                           
								    result += (Time)m[i];
                           return result;
                       }
                   }    
                   public override void Narastająco() {
                       narastająco = true;
                       for (int i=1; i<12; i++)
                           m[i] = (Time)m[i-1] + (Time)m[i];
                   }               
               }
                
               readonly public bool liczCzasPracy = false;
               readonly Pracownik pracownik;
               readonly Przychody przychody;
               readonly PracHistoria historia;
               readonly ArrayList result = new ArrayList();
               readonly ArrayList result2 = new ArrayList();

		       public Total(Pracownik pracownik, FromTo okres, Przychody przychody, string str_CultureInfo) {
                   this.pracownik = pracownik;
			       this.przychody = przychody;
                   this.historia = pracownik[okres.To];
                   PlaceModule pl = PlaceModule.GetInstance(pracownik);

                   SubTable st = wgDatyWypłaty ? pl.WypElementy.WgDaty[pracownik] : pl.WypElementy.WgPracownik[pracownik];
                   st = new SubTable(st, okres);
                   Hashtable elementy = new Hashtable();
                   foreach (WypElement e in st) {
                       if (!e.Wyplata.Zatwierdzona)
                           continue;
                       if (Filter(e.Wyplata) && !WypłataPoZgonie(e.Wyplata)) {
						    liczCzasPracy |= e.Wyplata is WyplataEtat;
                            ArrayList al = (ArrayList)elementy[e.Definicja];
                            if (al==null) {
                                al = new ArrayList();
                                elementy.Add(e.Definicja, al);
                            }
                            al.Add(e);
                       }
                   }

                   if (elementy.Count>0) {
                       result.Add(new DecimalItem(Str_WynPotr, 0));
                              
                       DecimalItem brutto = new DecimalItem(Str_RazemBrutto, 10);
                       result.Add(brutto);
                       DecimalItem podstawaZUS = new DecimalItem(Str_PodstawaSkladek, 20);
                       result.Add(podstawaZUS);
				       DecimalItem zus = new DecimalItem(Str_SkladkiNaUS, 30);
                       result.Add(zus);
				       DecimalItem koszty = new DecimalItem(Str_KosztyUzyskania, 40);
                       result.Add(koszty);
				       DecimalItem podstawa = new DecimalItem(Str_Podstawa, 50);
                       result.Add(podstawa);
				       DecimalItem ulga = new DecimalItem(Str_UlgaPodatkowa, 60);
                       result.Add(ulga);
				       DecimalItem zdrow775 = new DecimalItem(Str_Skladka775, 70);
                       result.Add(zdrow775);
				       DecimalItem zdrow025 = new DecimalItem(Str_Skladka025, 80);
                       result.Add(zdrow025);
				       DecimalItem zan = new DecimalItem(Str_ZaniechaniePoboru, 90);
                       result.Add(zan);
				       DecimalItem pit = new DecimalItem(Str_Zaliczka, 100);
                       result.Add(pit);
				       DecimalItem netto = new DecimalItem(Str_WynagrNetto, 110);
                       result.Add(netto);
				       DecimalItem narastająco = new DecimalItem(Str_WynagrNarastajaco, 120);
                       result.Add(narastająco);
				       DecimalItem wypłata = new DecimalItem(Str_Wyplata, 130);
                       result.Add(wypłata);

                       foreach (DefinicjaElementu def in elementy.Keys) {
                           bool opodat = def.Info.Opodatkowany;
                           DecimalItem item = new DecimalItem(def.GetLocalizedNazwa(new System.Globalization.CultureInfo(str_CultureInfo)), opodat ? 0 : 11);
                           foreach (WypElement e in (IEnumerable)elementy[def]) {
                               int m = wgDatyWypłaty ? e.Data.Month : e.Okres.To.Month;
                               item.Add(e.Wartosc, m);
                           
                               decimal sz = e.Podatki.KosztyZUS;
                               //TID: 3997, tyle że tutaj akurat był to błąd
                               //decimal z775 = e.Podatki.ZdrowotneFaktycznieOdliczon e;
                               decimal z775 = e.Podatki.ZdrowotneDoOdliczenia;
                               decimal z025 = e.Podatki.Zdrowotna.Prac - z775;

                               if (opodat) {
                                   decimal w = e.Wartosc;
                                   decimal k = e.Podatki.KosztyPIT;
                                   decimal zf = e.Podatki.Zaniechanie;
                                   decimal f = e.Podatki.ZalFIS;
                                   decimal n = w - sz - z775 - z025 - f;
                                   brutto.Add(w, m);
                                   koszty.Add(k, m);
                                   podstawa.Add(w - sz - k, m);
                                   ulga.Add(e.Podatki.Ulga, m);
                                   zan.Add(zf, m);
                                   pit.Add(f, m);
                                   netto.Add(n, m);
                                   narastająco.Add(n, m);
                               }

                               decimal pzus = e.Podatki.Emerytalna.Podstawa;
                               podstawaZUS.Add(pzus, m);

                               zus.Add(sz, m);
                               zdrow775.Add(z775, m);
                               zdrow025.Add(z025, m);
                           
                               wypłata.Add(e.DoWypłaty, m);
                           }
                           result.Add(item);
                       }
    
					    if (liczCzasPracy)
						    LiczCzasPracy(okres);
						
					    narastająco.Narastająco();
					    podstawaZUS.Narastająco();
					    result.Sort();
				    }
			    }
			    bool Filter(Soneta.Place.Wyplata w) {
				    switch(przychody) {
					    case Przychody.PracownikaZleceniobiorcy:
						    return true;
					    default:
						    return (w.Typ==TypWyplaty.Umowa)==(przychody==Przychody.Zleceniobiorcy);
				    }
			    }
			    void LiczCzasPracy(FromTo okres) {
				    IntItem ndni = null;
				    TimeItem nczas = null;
				    if (normaInfo) {
					    result2.Add(new IntItem(Str_NormaCzasu, 0));
					    ndni = new IntItem(Str_DniPracy, 1);
					    result2.Add(ndni);
					    nczas = new TimeItem(Str_CzasPracy, 2);
					    result2.Add(nczas);
                    }
                
                    IntItem dni = null;
                    TimeItem akordy = null;
                    TimeItem czas = null;
                    TimeItem n50 = null;
                    TimeItem n100 = null;
                    if (pracaInfo) {
					    result2.Add(new IntItem(Str_RzeczywistyCzas, 3));
					    dni = new IntItem(Str_DniPracy, 4);
					    result2.Add(dni);
					    akordy = new TimeItem(Str_CzasNaAkordach, 5);
					    result2.Add(akordy);
					    czas = new TimeItem(Str_PozostalyCzas, 6);
					    result2.Add(czas);
					    n50 = new TimeItem(Str_Czas50, 7);
					    result2.Add(n50);
					    n100 = new TimeItem(Str_Czas100, 8);
					    result2.Add(n100);
				    }
                
                    Periods zatrudniony = Periods.Empty;
                    foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okres))
					    zatrudniony += ph.Etat.EfektywnyOkres;
				    zatrudniony = zatrudniony.ToFlat();
				    zatrudniony *= okres;
				    zatrudniony = zatrudniony.BreakByMonth();
				
				    KalkulatorPracownika kalk = new KalkulatorPracownika(pracownik);
					
				    foreach (FromTo zatr in zatrudniony) {
					    int m = zatr.To.Month;
				
					    if (pracaInfo)
						    try {
							    CzasDni cd = kalk.Praca(zatr);	
							    ZestawienieNadgodzin nad = kalk.Nadgodziny(zatr);
							    Odchylka odch = kalk.KalkPracy.Odchylki(zatr);
						
							    dni.Add(cd.Dni, m);
							    akordy.Add(odch.Akordy, m);
							    czas.Add(cd.Czas - odch.Akordy, m);
							    n50.Add(nad.N50, m);
							    n100.Add(nad.N100 + nad.NSW, m);
						    }
						    catch {
						    }
					
					    if (normaInfo) {
						    CzasDni ncd = kalk.Norma(zatr);	
						    ndni.Add(ncd.Dni, m);
						    nczas.Add(ncd.Czas, m);
					    }					
				    }
               }
               public Pracownik Pracownik {
                   get { return pracownik; }
               }
               public PracHistoria Historia {
                   get { return historia; }
               }
               public Przychody Przychody {
                   get { return przychody; }
               }
               public bool Wchodzi {
                   get { return result.Count>0; }
               }
               public IEnumerable Elementy {
                   get { return result; }
               }
               public IEnumerable Praca {
                   get { return result2; }
               }
               public int CompareTo(object obj) {
                   if (obj==null)
                       return 1;
                   Total t = obj as Total;
                   if (t==null)
                       throw new ArgumentException();
                   return pracownik.CompareTo(t.pracownik);
               }
           }
       
		    [Flags]
		    public enum Przychody
		    {
			    [Caption("Pracownika")]
			    Pracownika = 0x01,
			    [Caption("Zleceniobiorcy")]
			    Zleceniobiorcy = 0x02,
			    [Caption("Pracownika/Zleceniobiorcy")]
			    PracownikaZleceniobiorcy = Pracownika | Zleceniobiorcy,
			    [Caption("Razem")]
			    Razem = 0x99,
		    }
    
           public class PrnParams: Soneta.Business.ContextBase {
               public PrnParams(Context context): base(context) {
                   Date data = ((ActualDate)context[typeof(ActualDate)]).Actual;
                   okres = FromTo.Year(data.Year);
               }
               FromTo okres;
		    [Soneta.Business.Required]
               [Priority(1)]
		       [Caption("Okres")]
               public FromTo Okres {
                   get { return okres; }
                   set {
                       if (value == FromTo.Empty)
                           value = FromTo.All;
                       okres = value;
                       OnChanged(EventArgs.Empty);
                   }
               }
               Przychody przychody = Przychody.Pracownika;
               [Priority(3)]
		       [Caption("Przychody")]
               public Przychody Przychody {
			    get { return przychody; }
			    set { 
				    przychody = value; 
                    OnChanged(EventArgs.Empty);
			    }
               }
           }
    
		    PrnParams pars;
		    [Soneta.Business.Context(Required=true)]
		    public PrnParams Params {
			    get { return pars; }
			    set { pars = value; }
		    }
    
		    string nazwaOkresu;

            protected void OnContextLoad(Object sender, EventArgs args) {
                if (pars.Okres == FromTo.Year(pars.Okres.From.Year))
                    nazwaOkresu = pars.Okres.From.Year + Str_Rok;
                else
                    nazwaOkresu = Str_Okres + pars.Okres.ToString();

                Pracownik pracownik = (Pracownik)dc[typeof(Pracownik)];

                ArrayList result = new ArrayList();

                if (pars.Przychody == Przychody.Razem)
                    Przelicz(result, pracownik, Przychody.PracownikaZleceniobiorcy);
                else {
                    Przelicz(result, pracownik, Przychody.Pracownika);
                    Przelicz(result, pracownik, Przychody.Zleceniobiorcy);
                }
                DataRepeater1.DataSource = result;
            }
    
		    void Przelicz(ArrayList lista, Pracownik pracownik, Przychody przychody) {
			    if ((pars.Przychody&przychody)!=0) {
				    Total t = new Total(pracownik, pars.Okres, przychody, Str_CultureInfo);
				    if (t.Wchodzi)
					    lista.Add(t);
			    }
		    }
    
		    protected void OnBeforeRow(Object sender, EventArgs args) {
               Total t = (Total)DataRepeater1.CurrentRow;
           
			    if (!t.liczCzasPracy) {
				    Grid1.ShowHeader = ShowHeader.Default;
				    Grid2.Visible = false;
			    }
			    else {
				    Grid1.ShowHeader = ShowHeader.None;
				    Grid2.Visible = true;
			    }
			
			    string info;
			    if (t.Przychody!=Przychody.PracownikaZleceniobiorcy)
				    info = " " + CaptionAttribute.EnumToString(t.Przychody, new System.Globalization.CultureInfo(Str_CultureInfo)).ToLower();
			    else
				    info = "";

			    //this.Title = Str_Title;
               ReportHeader1.Title = String.Format(Str_ReportTitle,
                   nazwaOkresu,
                   t.Pracownik.NazwiskoImię,
                   t.Historia.Urodzony.Data, t.Historia.Urodzony.Miejsce,
                   t.Historia.NIP, t.Historia.PESEL,
                   t.Historia.Adres,
                   info,
                   wgDatyWypłaty ? Str_WgDatyWyplaty : Str_WgOkresuElementu);
           }

        public static bool WypłataPoZgonie(Soneta.Place.Wyplata wypłata) {
		    WyplataUmowa wu = wypłata as WyplataUmowa;
		    Ubezpieczenia ubezpieczenia = null;
		    if (wu!=null) {
			    Umowa umowa = wu.Umowa;
			    if (umowa!=null)
				    ubezpieczenia = umowa[wypłata.Data].Ubezpieczenia;
		    }
		    else
			    ubezpieczenia = wypłata.Pracownik[wypłata.ListaPlac.Okres.To].Etat.Ubezpieczenia;
		
		    return ubezpieczenia!=null && ubezpieczenia.Zdrowotne.ZgonPracownika(wypłata.Data);
        }
    }
}
